/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.EasingFunctions;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ViewportEvent;

public class SpeedVaultAnimator
extends Animator {
    private static final int MAX_TIME = 11;
    private Type type;

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return this.getTick() >= 11;
    }

    private float getFactor(float tick) {
        float phase = tick / 11.0f;
        if ((double)phase < 0.5) {
            return EasingFunctions.SinInOutBySquare(phase * 2.0f);
        }
        return EasingFunctions.SinInOutBySquare(2.0f - phase * 2.0f);
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 11.0f;
        float factor = this.getFactor((float)this.getTick() + rotator.getPartialTick());
        float forwardFactor = (float)Math.sin((double)(phase * 2.0f) * Math.PI) + 0.5f;
        rotator.startBasedCenter().rotateRightward(factor * 70.0f * (float)(this.type == Type.Right ? -1 : 1)).rotateFrontward(30.0f * forwardFactor).end();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 11.0f;
        float factor = this.getFactor((float)this.getTick() + transformer.getPartialTick());
        switch (this.type) {
            case Right: {
                transformer.rotateLeftArm((float)Math.toRadians(MathUtil.lerp(-45.0f, 45.0f, phase)), 0.0f, (float)(-Math.toRadians(factor * 70.0f))).addRotateRightLeg(0.0f, 0.0f, (float)Math.toRadians(factor * 25.0f)).addRotateLeftLeg(0.0f, 0.0f, (float)Math.toRadians(factor * 15.0f)).end();
                break;
            }
            case Left: {
                transformer.rotateRightArm((float)Math.toRadians(MathUtil.lerp(-45.0f, 45.0f, phase)), 0.0f, (float)Math.toRadians(factor * 70.0f)).addRotateRightLeg(0.0f, 0.0f, (float)Math.toRadians(factor * -15.0f)).addRotateLeftLeg(0.0f, 0.0f, (float)Math.toRadians(factor * -25.0f)).end();
            }
        }
    }

    @Override
    public void onCameraSetUp(ViewportEvent.ComputeCameraAngles event, Player clientPlayer, Parkourability parkourability) {
        if (!Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || ((Boolean)ParCoolConfig.CONFIG_CLIENT.disableCameraVault.get()).booleanValue()) {
            return;
        }
        float factor = this.getFactor((float)((double)this.getTick() + event.getPartialTick()));
        float phase = (float)(((double)this.getTick() + event.getPartialTick()) / 11.0);
        float forwardFactor = (float)Math.sin((double)(phase * 2.0f) * Math.PI) + 0.5f;
        event.setPitch(15.0f * forwardFactor);
        switch (this.type) {
            case Right: {
                event.setRoll(-25.0f * factor);
                break;
            }
            case Left: {
                event.setRoll(25.0f * factor);
            }
        }
    }

    public SpeedVaultAnimator(Type type) {
        this.type = type;
    }

    public static enum Type {
        Right,
        Left;

    }
}

